package de.test.location;

import java.util.List;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

public class main extends Activity {

	private LocationManager lm;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		update_gps_pos();
	}

	public void onStop() {
		super.onStop();
		lm.removeUpdates(locationListener);
	}

	private double[] getPos() {
		LocationManager lm = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
		List<String> providers = lm.getProviders(true);

		Location l = null;

		for (int i = providers.size() - 1; i >= 0; i--) {
			l = lm.getLastKnownLocation(providers.get(i));
			if (l != null)
				break;
		}

		double[] gps = new double[2];
		if (l != null) {
			gps[0] = l.getLatitude();
			gps[1] = l.getLongitude();
		}
		return gps;
	}

	public void getPosition(View v) {
		double[] pos = getPos();
		TextView lat = (TextView) findViewById(R.id.lat);
		TextView lng = (TextView) findViewById(R.id.lng);

		lat.setText("Latitude: " + pos[0]);
		lng.setText("Latitude: " + pos[1]);
	}

	/**
	 * This function tells the gps-device to get new data every 10 seconds
	 */
	private void update_gps_pos() {
		lm = (LocationManager) getApplicationContext().getSystemService(
				Context.LOCATION_SERVICE);
		lm.requestLocationUpdates("gps", 10000, // 10 seconds
				1, // 10m
				locationListener);
	}

	/**
	 * This listener just shows a message if no gps-function is available
	 */
	private final LocationListener locationListener = new LocationListener() {
		public void onLocationChanged(Location l) {
		}

		public void onProviderDisabled(String provider) {
		}

		public void onProviderEnabled(String provider) {
		}

		public void onStatusChanged(String provider, int status, Bundle extras) {
		}
	};

}